function [T, H_rad] = radiogenic_heat_production_constant(H_rad_surf,hr,T_0,Y_T,nt,dt_diff_T,time,DcT,rho_c,dx_T,dy_T)

H_rad = H_rad_surf.* (ones(size(Y_T)));                                    % constant radiogenic heat production

% Modify the initial temperature profile:

T = T_0;

for it=2:1e4
    
    T_old = T;
    
    dt    = dt_diff_T;
    time  = time + dt;
    
    qx    = - DcT*diff(T(:,2:end-1),1,1)/dx_T;
    qy    = - DcT*diff(T(2:end-1,:),1,2)/dy_T;
    dTdt  = diff(-qx,1,1)/dx_T +  diff(-qy,1,2)/dy_T + H_rad(2:end-1,2:end-1)/rho_c;
    T(2:end-1,2:end-1) = T(2:end-1,2:end-1) + dTdt*dt;
    
    T(1,  :)  = T(2,    :);
    T(end,:)  = T(end-1,:);
    
    if mod(it,1e20)==0
        diff_T      = max(max(abs(T-T_old)));
        hold off
        plot(T(10,:)-273.15,Y_T(10,:),'k-')
        hold on
        plot(T_0(10,:)-273.15,Y_T(10,:),'k--')
        title(['Time step: ',num2str(it),' ; T-difference: ',num2str(diff_T)])
        drawnow
    end
    
end

end